// winbotDoc.cpp : implementation of the CWinbotDoc class
//

#include <assert.h>
#include "stdafx.h"
#include "winbot.h"

#include "winbotDoc.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CWinbotDoc

IMPLEMENT_DYNCREATE(CWinbotDoc, CDocument)

BEGIN_MESSAGE_MAP(CWinbotDoc, CDocument)
	//{{AFX_MSG_MAP(CWinbotDoc)
	ON_COMMAND(ID_VIEW_CHAT_UPDATES, OnViewChatUpdates)
	ON_UPDATE_COMMAND_UI(ID_VIEW_CHAT_UPDATES, OnUpdateViewChatUpdates)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()



const unsigned int MAX_LINES = 500;

/////////////////////////////////////////////////////////////////////////////
// CWinbotDoc construction/destruction

#pragma warning( disable : 4355) // 'this' used in initialization.. don't worry about it
CWinbotDoc::CWinbotDoc():TheBot(this)
{
	aszText.SetSize(MAX_LINES);

	uiTop = 0;
	uiBottom = 0;

	bViewChatUpdates = TRUE;

	// initialize WinSock
	WSADATA wsadata;
	int rc = WSAStartup(0x101,&wsadata);
	ASSERT (rc == 0); //Cannot initialize socket library.
	ASSERT (wsadata.wVersion == 0x101); //Incorrect socket library version.
}


CWinbotDoc::~CWinbotDoc()
{
	TheBot.Disconnect();
}

BOOL CWinbotDoc::OnNewDocument()
{
	if (!CDocument::OnNewDocument())
		return FALSE;

	uiTop = 0;
	uiBottom = 0;

	// NOTE: replace the username and password below with the actual
	// username and password of your bot
	TheBot.SetLogonInfo("Guest", "guest", "battle.net");

	// tell the bot where you want it to hang out
	TheBot.SetHomeChannel("The Void");

	POSITION pos = GetFirstViewPosition();
	CView* pFirstView = GetNextView( pos );
	TheBot.Reconnect(pFirstView->m_hWnd);

	return TRUE;
}



/////////////////////////////////////////////////////////////////////////////
// CWinbotDoc serialization

void CWinbotDoc::Serialize(CArchive& ar)
{
	if (ar.IsStoring())
	{
		// TODO: add storing code here
	}
	else
	{
		// TODO: add loading code here
	}
}

/////////////////////////////////////////////////////////////////////////////
// CWinbotDoc diagnostics

#ifdef _DEBUG
void CWinbotDoc::AssertValid() const
{
	CDocument::AssertValid();
}

void CWinbotDoc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CWinbotDoc commands
///

void CWinbotDoc::PutLine(char * szNewString, int nFlags)
{

	aszText[uiBottom].Format("%s", szNewString);
	aszText[uiBottom].m_nFlags = nFlags;

	uiBottom++;

	if (uiBottom >= MAX_LINES)
		uiBottom = 0;

	if (uiBottom == uiTop)
		uiTop++;

	if (uiTop >= MAX_LINES)
		uiTop = 0;

	if (bViewChatUpdates) 
		UpdateAllViews(NULL, 0);
}


unsigned int CWinbotDoc::GetNumberOfLines()
{
	unsigned int rc;

	if (uiTop>uiBottom)
		rc = (MAX_LINES - uiTop) + uiBottom;
	else
		rc = uiBottom - uiTop;

	return rc;
}

int CWinbotDoc::GetFirstLine(int iWhichLine, CString & szLine, int & nFlags)
{
	int iRC;

	if (uiTop>uiBottom)
	{ /* buffer has circled */
		int t = iWhichLine + uiTop;

		if (t < MAX_LINES)
			iRC = t;
		else
		{
			t = t - MAX_LINES;

			if (t < (int)uiBottom)
				iRC = t;
			else
				iRC = -1;
		}
	}
	else
	{
		int t = iWhichLine + uiTop;

		if ((t < MAX_LINES) && (t < (int)uiBottom))
			iRC = t;
		else
			iRC = -1;
	}

	if (iRC != -1)
	{
		szLine = aszText[iRC];
		nFlags = aszText[iRC].m_nFlags;
	}

	return iRC;
}

int CWinbotDoc::GetNextLine(int iLastLine, CString & szLine, int & nFlags)
{
	int iRC;

	if (iLastLine < 0)
	{
		iRC = uiTop;
		szLine = aszText[uiTop];
		nFlags = aszText[uiTop].m_nFlags;
	}
	else
	{
		iRC = iLastLine + 1;

		if (iRC >= MAX_LINES)
			iRC = 0;

		if (iRC == (int)uiBottom)
			iRC = -1;
		else
		{
			szLine = aszText[iRC];
			nFlags = aszText[iRC].m_nFlags;
		}
	}

	return iRC;
}

void CWinbotDoc::HandleBotSocketMessages(WPARAM wParam, LPARAM lParam)
{
	POSITION pos = GetFirstViewPosition();
	CView* pFirstView = GetNextView( pos );

	switch (lParam)
	{
		case FD_READ:
			if (TheBot.MsgLoop() == 0)
			{
				TheBot.Disconnect();
				TheBot.Reconnect(pFirstView->m_hWnd);
			}
			break;
		case FD_CLOSE:
			TheBot.Disconnect();
			TheBot.Reconnect(pFirstView->m_hWnd);
			break;
		default:
			ASSERT(FALSE);
			break;
	}
}

void CWinbotDoc::OnViewChatUpdates() 
{
	bViewChatUpdates = !bViewChatUpdates;
}

void CWinbotDoc::OnUpdateViewChatUpdates(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck(bViewChatUpdates);	
}
