// winbotView.cpp : implementation of the CWinbotView class
//

#include "stdafx.h"
#include "winbot.h"

#include "winbotDoc.h"
#include "winbotView.h"

#include <assert.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

const int INITIAL_SIZE = 100;		/* pixels */
const int LEFT_MARGIN = 20;			/* pixels */
const int TAB_STOP = 350;			/* pixels */
const int LINE_SPACING = 1;			/* pixels */
const int PAGE_WIDTH = 132;			/* characters */

/////////////////////////////////////////////////////////////////////////////
// CWinbotView

IMPLEMENT_DYNCREATE(CWinbotView, CScrollView)

const UINT	wm_ScrollToEnd = RegisterWindowMessage( "ScrollViewToEnd" );

BEGIN_MESSAGE_MAP(CWinbotView, CScrollView)
	//{{AFX_MSG_MAP(CWinbotView)
	ON_WM_ERASEBKGND()
	ON_WM_SHOWWINDOW()
	//}}AFX_MSG_MAP
	// Standard printing commands
	ON_COMMAND(ID_FILE_PRINT, CScrollView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_DIRECT, CScrollView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, CScrollView::OnFilePrintPreview)
    ON_REGISTERED_MESSAGE( wm_ScrollToEnd, OnScrollToEnd )
	ON_MESSAGE(SOCKET_MESSAGE, OnSocketMessage)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CWinbotView construction/destruction

CWinbotView::CWinbotView()
{
	// TODO: add construction code here
}

CWinbotView::~CWinbotView()
{
}

BOOL CWinbotView::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return CScrollView::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
// CWinbotView drawing

void CWinbotView::OnDraw(CDC* pDC)
{
// Flicker-free stuff: - NOTE.. I left this out accidentaly sort of. The view
// I wrote for work was totally flicker-free. I forgot to bring that part home
// when I wrote this bot.. sorry... -rm

//    CMemDC  pDC(dc);

	CSize	sTotalSize = GetTotalSize();
	CRect	rcClient;
    GetClientRect(&rcClient);

    CRect   rcBounds(0,0, __max(sTotalSize.cx,rcClient.right), __max(sTotalSize.cy, rcClient.bottom));
//    pDC->FillRect(rcBounds, CBrush::FromHandle((HBRUSH)GetStockObject(WHITE_BRUSH)));

// Normal drawing stuff:
	CWinbotDoc* pDoc = (CWinbotDoc*)GetDocument();
	ASSERT_VALID(pDoc);

	CString szString;

	TEXTMETRIC Metrics;
	pDC->GetOutputTextMetrics(&Metrics);
	CPoint pPos = GetScrollPosition();

	int iCurrentLine = 0;
// As long as the vertical scroll bar is not in the top slot, start drawing
// only the first visible line:
	if (pPos.y != 0)
		iCurrentLine = (pPos.y)/(Metrics.tmHeight+LINE_SPACING);

// We'll draw one line that is not visible. This will smooth the scrolling:
	if (iCurrentLine > 0)
		iCurrentLine -= 1;

// Now figure out the last line to be drawn:
	int iFinalLine = (pPos.y + rcClient.bottom)/(Metrics.tmHeight+LINE_SPACING);

	int nFlags;
	int iPrevLine = pDoc->GetFirstLine(iCurrentLine, szString, nFlags);
	int iPos;
	int iVertPos;

	while ((iPrevLine >= 0) && (iCurrentLine <= iFinalLine))
	{

		pDC->SetTextColor(RGB(0,0,0));

		iVertPos = (Metrics.tmHeight+LINE_SPACING)*iCurrentLine;
		iPos = szString.Find('\t');
		if (iPos != -1)
		{
			CString szHeader = szString.Left(iPos);
			CString szData = szString.Right(szString.GetLength() - iPos - 1);
			pDC->TextOut(LEFT_MARGIN, iVertPos, szHeader);
			pDC->TextOut(TAB_STOP, iVertPos, szData);
		}
		else
		{
			pDC->TextOut(LEFT_MARGIN, iVertPos, szString);
		}

		iPrevLine = pDoc->GetNextLine(iPrevLine, szString, nFlags);
		iCurrentLine++;
	}
}

void CWinbotView::OnInitialUpdate()
{
	CScrollView::OnInitialUpdate();
	CSize sizeTotal;
	// TODO: calculate the total size of this view
	sizeTotal.cx = sizeTotal.cy = 100;
	SetScrollSizes(MM_TEXT, sizeTotal);
}

/////////////////////////////////////////////////////////////////////////////
// CWinbotView printing

BOOL CWinbotView::OnPreparePrinting(CPrintInfo* pInfo)
{
	// default preparation
	return DoPreparePrinting(pInfo);
}

void CWinbotView::OnBeginPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add extra initialization before printing
}

void CWinbotView::OnEndPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add cleanup after printing
}

/////////////////////////////////////////////////////////////////////////////
// CWinbotView diagnostics

#ifdef _DEBUG
void CWinbotView::AssertValid() const
{
	CScrollView::AssertValid();
}

void CWinbotView::Dump(CDumpContext& dc) const
{
	CScrollView::Dump(dc);
}

CWinbotDoc* CWinbotView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CWinbotDoc)));
	return (CWinbotDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CWinbotView message handlers

BOOL CWinbotView::OnEraseBkgnd(CDC* pDC) 
{
	// TODO: Add your message handler code here and/or call default
	
	return CScrollView::OnEraseBkgnd(pDC);
// return FALSE;
}

LRESULT CWinbotView::OnScrollToEnd(WPARAM wParam, LPARAM lParam)
{

	int iMin, iMax;
	RECT r;

	GetScrollRange( SB_VERT, &iMin, &iMax );
	GetClientRect(&r);

	if (r.bottom <= iMax)
		SetScrollPos(SB_VERT, iMax, TRUE);

	return 1;

}

void CWinbotView::OnUpdate(CView* pSender, LPARAM lHint, CObject* pHint) 
{
	CDC* pDC = GetDC();
	ASSERT(pDC != NULL);

	TEXTMETRIC Metrics;
	pDC->GetOutputTextMetrics(&Metrics);

	CWinbotDoc* pDoc = (CWinbotDoc*)GetDocument();

	int iWidth = PAGE_WIDTH*Metrics.tmAveCharWidth;
	int iHeight = pDoc->GetNumberOfLines()*(Metrics.tmHeight + LINE_SPACING);

	SetScrollSizes(MM_TEXT, CSize(iWidth, iHeight), CSize(Metrics.tmAveCharWidth*10,Metrics.tmHeight*10), CSize(Metrics.tmAveCharWidth,Metrics.tmHeight));

	Invalidate();
	
// Interesting... if you try to make the scroll size smaller than
// the client window, MFC kinda ignores you and leaves it set to
// whatever it was set to before (which, in fact _could_ be much 
// larger than the client window). This plays havoc with my
// "ScrollToEnd" functionality. So, I'll make sure MFC has set
// the scroll size to what I specified before I queue the message
// to scroll the window to the bottom. A little messy, but if
// MFC wants to play rough, I guess I'll have to play rough too. 

	int iMin, iQueryHeight;
	GetScrollRange( SB_VERT, &iMin, &iQueryHeight );

	if ((iQueryHeight - iMin + 1) == iHeight)
		PostMessage(wm_ScrollToEnd);
}

void CWinbotView::OnShowWindow(BOOL bShow, UINT nStatus) 
{
	CScrollView::OnShowWindow(bShow, nStatus);
	
}


// OK, we got the socket message... don't do anything with it; just pass it
// to the document since he has TheBot.... 
afx_msg LRESULT CWinbotView::OnSocketMessage(WPARAM wParam, LPARAM lParam)
{
	CWinbotDoc * pDoc = (CWinbotDoc*)GetDocument();
	pDoc->HandleBotSocketMessages(wParam, lParam);

	return 1;
}

